//////////////////////////////////////////////////////////////////////////////////////////

#define _Yes_	  1
#define _No_	  2
#define _Error_   3
#define _Success_ 4

// These functions are prototype pre-defined. You can name them as you want.
void  WINAPI XServiceMain(DWORD dwNumServiceArgs, LPTSTR *lpServiceArgs);
void  WINAPI XControlHandler(DWORD dwControl);

// *** Global Service Variables
SERVICE_STATUS		  ServiceStatus;
SERVICE_STATUS_HANDLE ServiceStatusHandler = NULL;
HANDLE				  EventHandle		   = NULL;

DWORD WINAPI ServiceThread(LPVOID);
HANDLE ServiceThread_Handle = NULL;
DWORD ServiceThread_ID		= 0;

DWORD WINAPI EventThread(LPVOID);
HANDLE EventThread_Handle = NULL;
DWORD EventThread_ID	  = 0;

short xCommandService(DWORD);
short xIsServiceInstalled(void);
short xInstallService(void);
short xUninstallService(void);
short xStartService(void);
short xTriggerEvent(char *);

//////////////////////////////////////////////////////////////////////////////////////////

#define DisplayName  "NetWorkDLS HTTP-Server"
#define ServiceName  "DLS-HTTP-Server"

#define ServiceEventName	   "ServiceEventName"
#define OpenDialogEventName    "OpenDialogEventName"

//////////////////////////////////////////////////////////////////////////////////////////

DWORD WINAPI ServiceThread(LPVOID data)
{
    xMainEntry();

	SetEvent( EventHandle );

	return _Success_;
}

//////////////////////////////////////////////////////////////////////////////////////////

DWORD WINAPI EventThread(LPVOID data)
{
	HANDLE OpenDialogEvent = NULL;

	SECURITY_DESCRIPTOR SD;
	SECURITY_ATTRIBUTES SA;

	if(InitializeSecurityDescriptor(&SD, SECURITY_DESCRIPTOR_REVISION) == FALSE)
		return FALSE;

	if(SetSecurityDescriptorDacl(&SD, TRUE, 0, FALSE) == FALSE)
		return FALSE;

	SA.nLength			   = sizeof(SA);
	SA.lpSecurityDescriptor = &SD;
	SA.bInheritHandle	   = FALSE;

	OpenDialogEvent = CreateEvent( &SA, FALSE, FALSE, OpenDialogEventName );

	while(1)
	{
		if(WaitForSingleObject( OpenDialogEvent, 150 ) == WAIT_OBJECT_0)
		{
			ShowWindow(MainDialog_hWnd, SW_SHOW);
			SetFocus(MainDialog_hWnd);
		}

	}

	return _Success_;
}

//////////////////////////////////////////////////////////////////////////////////////////

short xServiceEntry(char *xCommand)
{
	// Create Service Data Array (Contains Information About Service)
	SERVICE_TABLE_ENTRY SrvTable[2];

	// Verify if service is running
	EventHandle = OpenEvent( SYNCHRONIZE, FALSE, ServiceEventName );
	if( EventHandle )
	{
		MessageBox( NULL, "SQLBackup service is active!", TitleCaption, MB_ICONINFORMATION );
		CloseHandle( EventHandle );
		return _Error_;
	}

	// Init Global Vars
	memset( &ServiceStatus, 0x00, sizeof(ServiceStatus) );
	EventHandle = NULL;

	// Load service
	SrvTable[0].lpServiceName = ServiceName;   // Service name
	SrvTable[0].lpServiceProc = XServiceMain;  // Service EntryPoint
	SrvTable[1].lpServiceName = NULL;		   // Nothing
	SrvTable[1].lpServiceProc = NULL;		   // Nothing

	// Pass the control to XServiceMain
	if( !StartServiceCtrlDispatcher(SrvTable) )
	{
		MessageBox( NULL, "Error starting SQLBackup service!", TitleCaption, MB_ICONERROR );
		return _Error_;
	}

	return _Success_;
}

//////////////////////////////////////////////////////////////////////////////////////////

void WINAPI XServiceMain(DWORD dwNumServiceArgs, LPTSTR *lpServiceArgs)
{
	DWORD Result = 0;

	// Register function that will receive messages from service manager
	// Must be the first action in Service Main
	ServiceStatusHandler = RegisterServiceCtrlHandler( ServiceName, (LPHANDLER_FUNCTION)XControlHandler );
	if( ServiceStatusHandler == (SERVICE_STATUS_HANDLE)NULL )
	{
		MessageBox( NULL, "Error in XServiceMain-RegisterServiceCtrlHandler !", TitleCaption, MB_ICONERROR );
		return;
	}

	// Create a semaphore to keep service alive
	EventHandle = CreateEvent( NULL, FALSE, FALSE, ServiceEventName );

	ServiceStatus.dwServiceType 			 = SERVICE_WIN32 | SERVICE_INTERACTIVE_PROCESS;
	ServiceStatus.dwCurrentState			 = SERVICE_RUNNING;
	ServiceStatus.dwControlsAccepted		 = SERVICE_ACCEPT_STOP | SERVICE_ACCEPT_SHUTDOWN;
	ServiceStatus.dwWin32ExitCode			 = NO_ERROR;
	ServiceStatus.dwServiceSpecificExitCode  = NO_ERROR;
	ServiceStatus.dwCheckPoint				 = 0;
	ServiceStatus.dwWaitHint				 = 0;

	// Make the first Status update
	Result = SetServiceStatus( ServiceStatusHandler, &ServiceStatus );
	if(!Result)
	{
		MessageBox( NULL, "Error in XServiceMain-SetServiceStatus !", TitleCaption, MB_ICONERROR );
		return;
	}

	RunningAsService = TRUE;

	// Start Main Service Thread (Program Will Brantch From That Thread)
	ServiceThread_Handle = CreateThread(NULL,0,ServiceThread,(LPVOID)0,0,&ServiceThread_ID);

	EventThread_Handle = CreateThread(NULL,0,EventThread,(LPVOID)0,0,&EventThread_ID);

	// Keep Service Running
	WaitForSingleObject( EventHandle, INFINITE );

	/* Service received a termination command */

	KillApplication();

	// Terminate Precision Timer Thread
	TerminateThread(ServiceThread_Handle,0);

	// Close Precision Timer Thread Handle
	CloseHandle(ServiceThread_Handle);

	ServiceStatus.dwCurrentState = SERVICE_STOPPED;
	SetServiceStatus( ServiceStatusHandler, &ServiceStatus );

	return;
}

//////////////////////////////////////////////////////////////////////////////////////////

void WINAPI XControlHandler(DWORD xMessage)
{
	DWORD Result = 0;

	// Receive messages from service control dispatcher
	switch (xMessage)
	{
//		case SERVICE_CONTROL_PAUSE :
//			ServiceStatus.dwWaitHint	 = 1000;
//			ServiceStatus.dwCurrentState = SERVICE_PAUSED;
//			break;

//		case SERVICE_CONTROL_CONTINUE :
//			ServiceStatus.dwWaitHint	 = 1000;
//			ServiceStatus.dwCurrentState = SERVICE_RUNNING;
//			break;

		case SERVICE_CONTROL_INTERROGATE :
			ServiceStatus.dwWaitHint	 = 500;
			break;

		case SERVICE_CONTROL_SHUTDOWN:
			ServiceStatus.dwWaitHint	 = 5000;
			ServiceStatus.dwCurrentState = SERVICE_STOP_PENDING;
			break;

		case SERVICE_CONTROL_STOP :
			ServiceStatus.dwWaitHint	 = 5000;
			ServiceStatus.dwCurrentState = SERVICE_STOP_PENDING;
			break;
	}

	// Update service status
	Result = SetServiceStatus( ServiceStatusHandler, &ServiceStatus );
	if (!Result)
	{
		MessageBox( NULL, "Error in XControlHandler-SetServiceStatus !", TitleCaption, MB_ICONERROR );
		SetEvent( EventHandle );
	}

	// If message is a stop or shutdown so, service is going to be stoped
	if ( (xMessage == SERVICE_CONTROL_STOP) || (xMessage == SERVICE_CONTROL_SHUTDOWN) )
		SetEvent( EventHandle );

}

//////////////////////////////////////////////////////////////////////////////////////////

/*
SERVICE_CONTROL_STOP
	Requests the service to stop. The hService handle must have SERVICE_STOP access.
SERVICE_CONTROL_PAUSE
	Requests the service to pause. The hService handle must have SERVICE_PAUSE_CONTINUE access.
SERVICE_CONTROL_CONTINUE
	Requests the paused service to resume. The hService handle must have SERVICE_PAUSE_CONTINUE access.
SERVICE_CONTROL_INTERROGATE
	Requests the service to update immediately its current status information to the service control manager. The hService handle must have SERVICE_INTERROGATE access.
SERVICE_CONTROL_SHUTDOWN
	The ControlService function fails if this control code is specified.
*/

short xCommandService(DWORD xCommand)
{
	SERVICE_STATUS ServiceStatus;
	SC_HANDLE ServiceControlHandle = NULL;
	SC_HANDLE ServiceHandle 	   = NULL;

	BOOL Result = FALSE;

	// UnInstall The Service From Service Control Manager Database
	ServiceControlHandle = OpenSCManager( NULL, NULL, SC_MANAGER_CREATE_SERVICE );
	if( ServiceControlHandle == NULL )
	{
		MessageBox( NULL, "Error in xStartService-OpenSCManager !", TitleCaption, MB_ICONERROR );
		return _Error_;
	}

	ServiceHandle = OpenService( ServiceControlHandle, ServiceName, SERVICE_ALL_ACCESS	);

	if( ServiceHandle == NULL )
	{
		MessageBox( NULL, "Error in xStartService-OpenService !", TitleCaption, MB_ICONERROR );
		CloseHandle(ServiceHandle);
		CloseHandle(ServiceControlHandle);
		return _Error_;
	}

	Result = ControlService(
		ServiceHandle,
		xCommand,
		&ServiceStatus 
	);

	if(Result == FALSE)
	{
		MessageBox( NULL, "Error in xCommandService-ControlService !", TitleCaption, MB_ICONERROR );
		CloseHandle(ServiceHandle);
		CloseHandle(ServiceControlHandle);
		return _Error_;
	}

	CloseHandle(ServiceHandle);
	CloseHandle(ServiceControlHandle);

	return _Success_;

}

//////////////////////////////////////////////////////////////////////////////////////////

short xStartService()
{
	SC_HANDLE ServiceControlHandle = NULL;
	SC_HANDLE ServiceHandle = NULL;
	BOOL Result = FALSE;

	// UnInstall The Service From Service Control Manager Database
	ServiceControlHandle = OpenSCManager( NULL, NULL, SC_MANAGER_CREATE_SERVICE );
	if( ServiceControlHandle == NULL )
	{
		MessageBox( NULL, "Error in xStartService-OpenSCManager !", TitleCaption, MB_ICONERROR );
		return _Error_;
	}

	ServiceHandle = OpenService( ServiceControlHandle, ServiceName, SERVICE_ALL_ACCESS	);

	if( ServiceHandle == NULL )
	{
		MessageBox( NULL, "Error in xStartService-OpenService !", TitleCaption, MB_ICONERROR );
		CloseHandle(ServiceHandle);
		CloseHandle(ServiceControlHandle);
		return _Error_;
	}

	Result = StartService(
		ServiceHandle,	// Handle Of Service
		NULL,			// Number Of Arguments
		NULL			// Address Of Array Of Argument String Pointers
	);

	if(Result == FALSE)
	{
		MessageBox( NULL, "Error in xStartService-StartService !", TitleCaption, MB_ICONERROR );
		CloseHandle(ServiceHandle);
		CloseHandle(ServiceControlHandle);
		return _Error_;
	}

	CloseHandle(ServiceHandle);
	CloseHandle(ServiceControlHandle);

	return _Success_;
}

//////////////////////////////////////////////////////////////////////////////////////////

short xInstallService(void)
{
	SC_HANDLE ServiceControlHandle;
	SC_HANDLE ServiceHandle;

	char ServerApp[256];

	GetModuleFileName(MainInstance, ServerApp, 256);

	// Install the Service In The Control Manager Database
	ServiceControlHandle = OpenSCManager( NULL, NULL, SC_MANAGER_CREATE_SERVICE );
	if( ServiceControlHandle == NULL )
	{
		MessageBox( NULL, "Error in xInstallService-OpenSCManager !", TitleCaption, MB_ICONERROR );
		return _Error_;
	}

	ServiceHandle = CreateService(
		ServiceControlHandle,
		ServiceName,
		DisplayName,
		SERVICE_ALL_ACCESS,
		SERVICE_WIN32_OWN_PROCESS | SERVICE_INTERACTIVE_PROCESS,
		SERVICE_AUTO_START,
		SERVICE_ERROR_NORMAL,
		ServerApp,
		NULL,
		NULL,
		NULL,
		NULL,
		NULL );

	if( ServiceHandle == NULL )
	{
		MessageBox( NULL, "Error in xInstallService-CreateService !", TitleCaption, MB_ICONERROR );
		CloseHandle( ServiceControlHandle );
		return _Error_;
	}

	CloseHandle( ServiceHandle );
	CloseHandle( ServiceControlHandle );

	return _Success_;
}

//////////////////////////////////////////////////////////////////////////////////////////

short xUninstallService(void)
{
	SC_HANDLE ServiceControlHandle;
	SC_HANDLE ServiceHandle;

	// UnInstall The Service From Service Control Manager Database
	ServiceControlHandle = OpenSCManager( NULL, NULL, SC_MANAGER_CREATE_SERVICE );
	if( ServiceControlHandle == NULL )
	{
		MessageBox( NULL, "Error in xUninstallService-OpenSCManager !", TitleCaption, MB_ICONERROR );
		return _Error_;
	}

	ServiceHandle = OpenService( ServiceControlHandle, ServiceName, SERVICE_ALL_ACCESS	);

	if( ServiceHandle == NULL )
	{
		MessageBox( NULL, "Error in xUninstallService-OpenService !", TitleCaption, MB_ICONERROR );
		CloseHandle(ServiceHandle);
		CloseHandle(ServiceControlHandle);
		return _Error_;
	}

	if( !DeleteService(ServiceHandle) )
	{
		MessageBox( NULL, "Error in xUninstallService-DeleteService !", TitleCaption, MB_ICONERROR );
		return _Error_;
	}

	CloseHandle(ServiceHandle);
	CloseHandle(ServiceControlHandle);

	return _Success_;
}

//////////////////////////////////////////////////////////////////////////////////////////

short xIsServiceInstalled(void)
{
	SC_HANDLE ServiceControlHandle;
	SC_HANDLE ServiceHandle;

	ServiceControlHandle = OpenSCManager( NULL,  NULL, SC_MANAGER_CREATE_SERVICE );
	if( ServiceControlHandle == NULL )
	{
		MessageBox( NULL, "Error in xIsServiceInstalled-OpenSCManager !", TitleCaption, MB_ICONERROR );
		return _Error_;
	}

	ServiceHandle = OpenService( ServiceControlHandle, ServiceName, SERVICE_ALL_ACCESS	);

	if( ServiceHandle == NULL)
	{
		CloseHandle( ServiceHandle );
		CloseHandle( ServiceControlHandle );
		return _No_;
	}

	CloseHandle( ServiceHandle );
	CloseHandle( ServiceControlHandle );

	return _Yes_;
}

//////////////////////////////////////////////////////////////////////////////////////////

short xTriggerEvent(char *xxEventName)
{
	HANDLE LocalEventHandle = NULL;

	LocalEventHandle = OpenEvent(EVENT_MODIFY_STATE, FALSE, OpenDialogEventName );

	if(!LocalEventHandle)
		return _Error_;

	if(!SetEvent(LocalEventHandle))
		return _Error_;

	return _Success_;
}

//////////////////////////////////////////////////////////////////////////////////////////

